#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));

const int N = 40;

int X[N], Y[N];
vector<int> E[N];
int C[N];

bool can[N][N];
int cnt[3];
int num[N][3];

vector<pair<int*, int> > ch;

void rollback(int s)
{
    while (ch.size() > s)
    {
        *ch.back().first = ch.back().second;
        ch.pop_back();
    }
}

bool go(int x)
{
    for (int c = 0; c < 3; c++)
    {
        if (num[x][c])
            continue;
        
        int s = ch.size();
        ch.push_back(make_pair(&C[x], C[x]));
        C[x] = c;
        ch.push_back(make_pair(&cnt[c], cnt[c]));
        ++cnt[c];
        bool bad = false;
        if (cnt[0] >= 12) {
            bad = true;
        }
        for (int i = 0; i < E[x].size() && !bad; i++)
        {
            int y = E[x][i];
            if (C[y] == -1)
            {
                ch.push_back(make_pair(&num[y][c], num[y][c]));
                ++num[y][c];
                if (num[y][0] && num[y][1] && num[y][2])
                    bad = true;
            }
        }
        if (!bad)
        {
            for (int i = 0; i < E[x].size() && !bad; i++)
            {
                int y = E[x][i];
                if (C[y] == -1)
                {
                    if (!go(y))
                    {
                        bad = true;
                    }
                }
            }
        }
        if (!bad)
            return true;
        rollback(s);
    }
    return false;
}


bool DFS(int x)
{
    for (int i = 0; i < E[x].size(); i++)
    {
        int y = E[x][i];
        if (C[y] == -1)
        {
            C[y] = !C[x];
            if (!DFS(y))
                return false;
        }
        else if (C[y] == C[x])
            return false;
    }
    return true;
}

struct vt
{
    int x, y;
    vt(int _x, int _y)
    {
        x = _x, y = _y;
    }
    friend vt operator -(vt a, vt b)
    {
        return vt(a.x - b.x, a.y - b.y);
    }
    friend int operator ^(vt a, vt b)
    {
        return a.x * b.y - b.x * a.y;
    }
    friend int operator *(vt a, vt b)
    {
        return a.x * b.x + a.y * b.y;
    }
    friend bool operator <(vt a, vt b)
    {
        return make_pair(a.x, a.y) < make_pair(b.x, b.y);
    }
};

map<pair<vt, vt>, int> M;

bool inter(vt a, vt b, vt c, vt d)
{
    if (((b - a) ^ (d - c)) != 0)
        return false;
    if (((c - a) ^ (b - a)) != 0)
        return false;
    vt v = b - a;
    if ((d - c) * v < 0)
        swap(c, d);
    if (c * v >= b * v || a * v >= d * v)
        return false;
    return true;
}

inline bool cmp(int a, int b) {
    return sz(E[a]) < sz(E[b]);
}

bool solve()
{
    eprintf(" ======= \n");
    int n;
    scanf("%d", &n);
    if (!n)
        return false;
    M.clear();
    for (int i = 0; i < n; i++)
        E[i].clear();
    for (int i = 0; i < n; i++)
    {
        int m;
        scanf("%d", &m);
        for (int j = 0; j < m; j++)
            scanf("%d %d", &X[j], &Y[j]);
        for (int j = 0; j < m; j++)
            M[make_pair(vt(X[j], Y[j]), vt(X[(j + 1) % m], Y[(j + 1) % m]))] = i;
    }
    for (map<pair<vt, vt>, int>::iterator it = M.begin(); it != M.end(); it++)
        for (map<pair<vt, vt>, int>::iterator it2 = M.begin(); it2 != M.end(); it2++)
        {
            int a = it->second;
            int b = it2->second;
            if (inter(it->first.first, it->first.second, it2->first.first, it2->first.second))
                E[a].push_back(b), E[b].push_back(a);
        }
    
    for (int x = 0; x < n; x++)
    {
        sort(E[x].begin(), E[x].end());
        E[x].resize(unique(E[x].begin(), E[x].end()) - E[x].begin());
        E[x].erase(find(E[x].begin(), E[x].end(), x));
        sort(all(E[x]), cmp);
        eprintf("%d ->", x);
        for (int i = 0; i < E[x].size(); i++)
            eprintf(" %d", E[x][i]);
        eprintf("\n");
    }
    
    bool col1 = true;
    for (int i = 0; i < n && col1; i++)
        if (!E[i].empty())
            col1 = false;
    if (col1)
    {
        puts("1");
        return true;
    }
    
    memset(C, -1, sizeof(int) * n);
    bool col2 = true;
    for (int i = 0; i < n && col2; i++)
        if (C[i] == -1)
            if (!DFS(i))
                col2 = false;
    if (col2)
    {
        puts("2");
        return true;
    }
    
    memset(C, -1, sizeof(int) * n);
    memset(num, 0, sizeof(int) * 3 * n);
    bool col3 = true;
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            can[i][j] = false;
        }
    }
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < sz(E[i]); ++j) {
            can[i][E[i][j]] = can[E[i][j]][i] = true;
        }
    }
    for (int i = 0; i < n - 3 && col3; ++i) {
        for (int j = i + 1; j < n - 2 && col3; ++j) {
            if (!can[i][j]) {
                continue;
            }
            for (int z = j + 1; z < n - 1 && col3; ++z) {
                if (!can[i][z] || !can[j][z]) {
                    continue;
                }
                for (int h = z + 1; h < n; ++h) {
                    if (can[i][h] && can[j][h] && can[z][h]) {
                        col3 = false;
                        break;
                    }
                }
            }
        }
    }
    if (col3) {
        cnt[0] = cnt[1] = cnt[2] = 0;
        vi perm(n);
        for (int i = 0; i < n; ++i) {
            perm[i] = i;
        }
        sort(all(perm), cmp);
        for (int i = 0; i < n && col3; i++)
            if (C[perm[i]] == -1)
                if (!go(perm[i]))
                    col3 = false;
    }
    if (col3)
    {
        puts("3");
        return true;
    }
    
    puts("4");
    return true;
}

int main() {
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
    while (solve());
    return 0;
}